/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDataFieldDetailsDialog;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItemRenderer;
import filenet.vw.toolkit.utils.dialog.VWFieldNameSelectorAddRemovePanel;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VWFieldNameSelectorDialog
extends VWModalDialog
implements ActionListener {
    private VWFieldNameSelectorAddRemovePanel m_addRemovePanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JButton m_detailsButton = null;
    private Vector m_selectedFieldList = null;
    private Vector m_hiddenSelectedList = new Vector();
    private Object[] m_availableItems = null;
    private Object[] m_selectedItems = null;
    private VWSystemConfiguration m_systemConfiguration = null;
    private Frame m_parentFrame = null;
    private boolean m_bCanceled = true;

    public VWFieldNameSelectorDialog(Frame parentFrame, VWSystemConfiguration systemConfiguration, Vector selectedFieldList, boolean bWarningOnDeprecatedTimeType) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_systemConfiguration = systemConfiguration;
        this.m_selectedFieldList = selectedFieldList;
        Dimension dim = VWStringUtils.stringToDimension("495,445");
        if (dim == null) {
            dim = new Dimension(450, 400);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_exposedDataFields);
        VWAccessibilityHelper.setAccessibility(this, null, VWResource.s_exposedDataFields, VWResource.s_exposedDataFields);
        this.initLayout();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            boolean isDuplicate = this.checkDuplicateFieldNames();
            if (!isDuplicate) {
                this.m_bCanceled = false;
                this.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(null, VWResource.s_duplicateFields, VWResource.s_error, 0, null);
            }
        } else if (object == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (object == this.m_detailsButton) {
            Object[] items = null;
            Object[] selectedItems = null;
            selectedItems = this.m_addRemovePanel.getSelectedItemsInAvailableList();
            if (selectedItems != null && selectedItems.length > 0) {
                items = selectedItems;
            } else {
                selectedItems = this.m_addRemovePanel.getSelectedItemsInSelectedList();
                if (selectedItems != null && selectedItems.length > 0) {
                    items = selectedItems;
                } else {
                    JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noFieldSelected, VWResource.s_warning, 1, null);
                }
            }
            if (items != null && items.length > 0) {
                VWDataFieldDetailsDialog dlg = new VWDataFieldDetailsDialog(this.m_parentFrame, items);
                dlg.setVisible(true);
            }
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwd051.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public boolean getStatus() {
        return this.m_bCanceled;
    }

    public Object[] getAvailableDataFields() {
        return this.m_addRemovePanel.getAvailableItems();
    }

    public Object[] getSelectedDataFields() {
        int i;
        if (this.m_hiddenSelectedList.size() == 0) {
            return this.m_addRemovePanel.getSelectedItems();
        }
        Vector<Object> aVector = new Vector<Object>();
        Object[] fields = this.m_addRemovePanel.getSelectedItems();
        if (fields != null) {
            for (i = 0; i < fields.length; ++i) {
                aVector.addElement(fields[i]);
            }
        }
        for (i = 0; i < this.m_hiddenSelectedList.size(); ++i) {
            aVector.addElement(this.m_hiddenSelectedList.elementAt(i));
        }
        Object[] selectedFields = new Object[aVector.size()];
        aVector.copyInto(selectedFields);
        return selectedFields;
    }

    private void initLayout() {
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            this.m_detailsButton = new JButton(VWResource.s_detailsDots);
            this.m_detailsButton.setEnabled(false);
            VWAccessibilityHelper.setAccessibility(this.m_detailsButton, this, VWResource.s_detailsDots, VWResource.s_detailsDots);
            JPanel selectorPanel = new JPanel();
            this.setupSelectorPanel(selectorPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(12, 12, 5, 12);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)selectorPanel, c);
            c.gridx = 0;
            ++c.gridy;
            c.fill = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 16, 12, 12);
            this.m_detailsButton.addActionListener(this);
            mainPanel.add((Component)this.m_detailsButton, c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel setupSelectorPanel(JPanel panel) {
        try {
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.setLayout(new BorderLayout());
            this.m_addRemovePanel = new VWFieldNameSelectorAddRemovePanel(this, 138);
            this.m_addRemovePanel.setAvailableItemName(VWResource.s_availableFields);
            this.m_addRemovePanel.setSelectedItemName(VWResource.s_selectedFields);
            this.m_addRemovePanel.setListCellRenderer(new VWDataFieldItemRenderer());
            this.m_addRemovePanel.enableSorting(3840);
            this.m_availableItems = this.initAvailableList();
            this.m_selectedItems = this.initSelectedList(this.m_selectedFieldList);
            this.m_addRemovePanel.initializeLists(this.m_availableItems, this.m_selectedItems);
            panel.add((Component)this.m_addRemovePanel, "Center");
            VWAccessibilityHelper.setAccessibility(this.m_addRemovePanel, this, null, null);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private Object[] initAvailableList() {
        try {
            Vector<VWDataFieldItem> names = new Vector<VWDataFieldItem>();
            try {
                VWExposedFieldDefinition[] fields = this.m_systemConfiguration.getExposedFields();
                if (fields != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        try {
                            if (fields[i] == null || fields[i].isSystemField()) continue;
                            VWDataFieldItem item = this.findItem(fields[i], names);
                            if (item == null) {
                                item = new VWDataFieldItem(fields[i]);
                                names.addElement(item);
                                continue;
                            }
                            item.addToSourceList(fields[i].getSourceName());
                            continue;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                    }
                    if (fields.length > 0 && this.m_detailsButton != null) {
                        this.m_detailsButton.setEnabled(true);
                    }
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
            if (names.size() > 0) {
                Object[] availableNames = new Object[names.size()];
                names.copyInto(availableNames);
                return availableNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private Object[] initSelectedList(Vector lists) {
        Vector<VWDataFieldItem> names = null;
        Object[] selectedNames = null;
        try {
            if (lists == null || lists.size() == 0) {
                return selectedNames;
            }
            names = new Vector<VWDataFieldItem>();
            try {
                for (int i = 0; i < lists.size(); ++i) {
                    VWDataFieldItem item = null;
                    Object fieldDef = lists.elementAt(i);
                    if (fieldDef == null) continue;
                    if (fieldDef instanceof VWExposedFieldDefinition) {
                        item = new VWDataFieldItem((VWExposedFieldDefinition)fieldDef);
                        if (item == null) continue;
                        names.addElement(item);
                        continue;
                    }
                    if (!(fieldDef instanceof VWFieldDefinition)) continue;
                    item = this.findItem((VWFieldDefinition)fieldDef, this.m_availableItems);
                    if (item != null) {
                        names.addElement(item);
                        continue;
                    }
                    item = new VWDataFieldItem((VWFieldDefinition)fieldDef);
                    if (item == null) continue;
                    this.m_hiddenSelectedList.addElement(item);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            if (names.size() > 0) {
                selectedNames = new Object[names.size()];
                names.copyInto(selectedNames);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return selectedNames;
    }

    private VWDataFieldItem findItem(VWExposedFieldDefinition obj, Vector aVector) {
        try {
            if (obj == null) {
                return null;
            }
            if (aVector == null || aVector.size() == 0) {
                return null;
            }
            for (int i = 0; i < aVector.size(); ++i) {
                VWDataFieldItem item;
                if (!(aVector.elementAt(i) instanceof VWDataFieldItem) || (item = (VWDataFieldItem)aVector.elementAt(i)) == null || VWStringUtils.compare(obj.getName(), item.getName()) != 0 || obj.getFieldType() != item.getType()) continue;
                if (obj.getFieldType() == 2) {
                    if (obj.getLength() != item.getLength()) continue;
                    return item;
                }
                return item;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private VWDataFieldItem findItem(VWFieldDefinition fieldDef, Object[] lists) {
        try {
            if (fieldDef == null) {
                return null;
            }
            if (lists == null || lists.length == 0) {
                return null;
            }
            for (int i = 0; i < lists.length; ++i) {
                VWDataFieldItem item;
                if (!(lists[i] instanceof VWDataFieldItem) || (item = (VWDataFieldItem)lists[i]) == null || VWStringUtils.compare(fieldDef.getName(), item.getName()) != 0) continue;
                switch (item.getType()) {
                    default: 
                }
                if (fieldDef.getFieldType() != item.getType()) continue;
                return item;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private boolean checkDuplicateFieldNames() {
        Object[] selectedFields = this.getSelectedDataFields();
        boolean isDuplicate = false;
        for (int i = 0; i < selectedFields.length; ++i) {
            if (!(selectedFields[i] instanceof VWDataFieldItem)) continue;
            VWDataFieldItem item = (VWDataFieldItem)selectedFields[i];
            String name = item.getName();
            for (int j = 0; j < selectedFields.length; ++j) {
                VWDataFieldItem anotherItem = (VWDataFieldItem)selectedFields[j];
                if (anotherItem == null || VWStringUtils.compare(name, anotherItem.getName()) != 0 || i == j) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) break;
        }
        return isDuplicate;
    }
}

